local TFC_DebugMenu = {}

local TABAS_Utils = require("TABAS_Utils")

function TFC_DebugMenu.donDebugMenu(tfc_Base, subMenu)
    if not tfc_Base:hasTfc() then return end

    local debugMenu = subMenu:addDebugOption("TFC Debug:")
    local debugSubMenu = ISContextMenu:getNew(subMenu)
    subMenu:addSubMenu(debugMenu, debugSubMenu)

    TFC_DebugMenu.debugAddFluid(tfc_Base, debugSubMenu, subMenu)
    -- Water to Full
    debugSubMenu:addOption("Fill Water: Full", tfc_Base, TFC_DebugMenu.debugWaterToFull)
    -- Water to Half
    debugSubMenu:addOption("Fill Water: Half", tfc_Base, TFC_DebugMenu.debugWaterToHalf)
    -- Set Temperature 22.0
    debugSubMenu:addOption("Set Temperature: 22C", tfc_Base, TFC_DebugMenu.debugSetTemperature)
    -- Water to Dirt +25
    debugSubMenu:addOption("Water to Dirt +25", tfc_Base, TFC_DebugMenu.debugWaterToDirt)
    -- Water to Clean
    debugSubMenu:addOption("Water to Clean", tfc_Base, TFC_DebugMenu.debugWaterToClean)
    -- Reset This TFC Object
    debugSubMenu:addOption("Clear This TFC", tfc_Base, TFC_DebugMenu.clearTfcObject)
    -- Clear Activate
    debugSubMenu:addOption("Clear All Activate", tfc_Base, TFC_DebugMenu.clearAllActivate)
    -- Clerr All TFC
    debugSubMenu:addOption("Clear All TFC", nil, TFC_DebugMenu.clearAllTfc)
end

function TFC_DebugMenu.debugAddFluid(tfc_Base, debugSubMenu, subMenu)
    local debugFluidOption = subMenu:addDebugOption("Add Fluid:")
    local addFluidSubMenu = ISContextMenu:getNew(subMenu)
    debugSubMenu:addSubMenu(debugFluidOption, addFluidSubMenu)
    -- Debug Add Fluid
    local addDebugFluid = function(tfc_Base, fluid)
        tfc_Base:removeFluid()
        tfc_Base:addFluid(fluid, tfc_Base:getCapacity())
        tfc_Base:setWaterTemperature(tfc_Base:getBathData("idealTemperature"))
    end
    local fluidNames = FluidType.getAllFluidName()
    for i=0, fluidNames:size() -1 do
        local fluidType = FluidType.FromNameLower(fluidNames:get(i))
        local fluid = Fluid.Get(fluidType)
        if fluid then
            addFluidSubMenu:addOption(fluidNames:get(i), tfc_Base, addDebugFluid, fluid)
        end
    end
end

function TFC_DebugMenu.debugWaterToFull(tfc_Base)
    local amount = tfc_Base:getCapacity()
    if tfc_Base:isEmpty() then
        tfc_Base:addFluid(Fluid.Water, amount)
    else
        tfc_Base:adjustAmount(amount)
    end
end

function TFC_DebugMenu.debugWaterToHalf(tfc_Base)
    local amount = tfc_Base:getCapacity() * 0.5
    if tfc_Base:isEmpty() then
        tfc_Base:addFluid(Fluid.Water, amount)
    else
        tfc_Base:adjustAmount(amount)
    end
end

function TFC_DebugMenu.debugSetTemperature(tfc_Base)
    tfc_Base:setWaterTemperature(22.0)
end

function TFC_DebugMenu.debugWaterToDirt(tfc_Base)
    if not tfc_Base:hasFluid() then
        print("This TFC object has not fulid!")
        return
    end
    tfc_Base:waterToDirt(25)
    print("Cuurent water dirty level >> " .. tfc_Base:getWaterData("dirtyLevel"))
end

function TFC_DebugMenu.debugWaterToClean(tfc_Base)
    if not tfc_Base:hasFluid() then
        print("This TFC object has not fulid!")
        return
    end
    local amount = tfc_Base:getAmount()
    tfc_Base:setWaterData("dirtyLevel", 0)
    tfc_Base:setWaterData("isDirty", false)
    tfc_Base:removeFluid()
    tfc_Base:addFluid(Fluid.Water, amount)
    print("Cuurent water dirty level >> " .. tfc_Base:getWaterData("dirtyLevel"))
end

function TFC_DebugMenu.clearTfcObject(tfc_Base)
    if tfc_Base:hasTfc() then
        tfc_Base:remove()
    else
        print("No TFC object there yet!")
    end
end

function TFC_DebugMenu.clearAllActivate()
    local gData = GetTFCSystemData()
    for k, v in pairs(gData.Activated) do
        if v.emitter then v.emitter:stopAll() end
        v.emitter = nil
        v = nil
        gData.Activated[k] = nil
    end
    TFCSystemTransmit()
end

function TFC_DebugMenu.clearAllTfc()
    local TFC_System = require("TABAS_TFCSystem")
    local gData = GetTFCSystemData()
    for k,v in pairs(gData.Registered) do
        local square = getCell():getGridSquare(v.x, v.y, v.z)
        if square then
            local tfc_Base = TABAS_Utils.getTfcBase(v.x, v.y, v.z, v.f)
            if tfc_Base and tfc_Base:hasTfc() then
                tfc_Base:remove()
                print("TFC object removed!: [" .. tostring(k) .. "] ")
            end
        else
            TFC_System.registPendedRemove(v.x, v.y, v.z, v.f)
            print("TFC object remove pended!: [" .. tostring(k) .. "] ")
        end
    end
    gData.Registered = {}
    TFCSystemTransmit()
end


return TFC_DebugMenu